#!/usr/bin/env python
# -*- coding: utf-8 -*-
from utils import *

class View:

    def __init__(self):
        self.cms = 'images'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self ):

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        dic.close()

        if scfg.get("PAGEMAKE"):
            if scfg.get("PAGEMAKE") == 'HTML':
                pages = GetHtmlMenuPages() 

        return render.images(  
                                cms = self.cms,                        
                                scfg = scfg, 
                                pages = pages,
                                mode = 'view',
                                id = None,
                                html_file = None,
        )


class Edit:

    def __init__(self):
        self.cms = 'images'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self, id="index" ):

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        fields = dic.get('fields')
        dic.close()

        try:
            file = codecs.open(PANEO_SITE_DATA_DIR+id+'.html',"r","utf8")
            bs = BeautifulSoup(file.read(),"html5lib",fromEncoding="utf8")
            file.close()
        except:
            return web.notfound()

        if fields is None:
            fields = {}

        html_fields = {}
        n = 0
        for img in bs.find_all('img'):
            paneo_type = img.get('data-paneo-type')
            paneo_name = img.get('data-paneo-name')
            title = img.get('title')
            if paneo_type is not None and paneo_name is not None:
                if paneo_type == "img":
                    k = ('img_%s_%s'%(id,paneo_name))
                    f = fields.get(k)
                    if f :
                        alt = f.get('alt') 
                        src = f.get('src') 
                        img_src = f.get('src') 
                        src_on = f.get('src_on')
                    else:
                        alt = img.get('alt') 
                        src = img.get('src') 
                        img_src = img.get('src') 
                        src_on = False 

                    #画像があるかどうかチェック
                    if os.path.exists(PANEO_SITE_DATA_DIR+'img/'+k) :
                        if src_on is False:
                            img_src = "/" + PANEO_SITE_DIR + "/img/" + k + "?" + dt

                    if title is None:
                        title = u"画像%s" % n

                    html_fields[k] = {  'idx':n , 'tag':'img' ,
                                        'paneo-type':paneo_type,
                                        'paneo-name':paneo_name,
                                        'title':title,
                                        'img_src':img_src,
                                        'src':src,
                                        'src_on':src_on, 
                                        'alt':alt } 
                    n = n + 1

        n = 101 
        for a in bs.find_all('a'):
            paneo_type = a.get('data-paneo-type')
            paneo_name = a.get('data-paneo-name')
            title = a.get('title')
            if paneo_type is not None and paneo_name is not None:
                if paneo_type == "link-image":

                    img = a.find('img')
                    k = ('img_%s_%s'%(id,paneo_name))
                    f = fields.get(k)
                    if f :
                        alt = f.get('alt') 
                        src = f.get('src') 
                        img_src = f.get('src') 
                        src_on = f.get('src_on')
                        href = f.get('href')
                    else:
                        alt = img.get('alt') 
                        src = img.get('src') 
                        img_src = img.get('src') 
                        src_on = False 
                        href = a.get('href')

                    #画像があるかどうかチェック
                    if os.path.exists(PANEO_SITE_DATA_DIR+'img/'+k) :
                        if src_on is False:
                            img_src = "/" + PANEO_SITE_DIR + "/img/" + k + "?" + dt

                    if title is None:
                        title = u"リンク画像%s" % n

                    html_fields[k] = { 'idx':n , 'tag':'img' ,
                                        'paneo-type':paneo_type,
                                        'paneo-name':paneo_name,
                                        'title':title,
                                        'img_src':img_src,
                                        'src':src,
                                        'src_on':src_on, 
                                        'alt':alt,
                                        'href':href } 
                    n = n + 1


        return render.images(     
                                    cms = self.cms,                        
                                    mode = 'edit',
                                    id = id,
                                    scfg = scfg, 
                                    pages = pages,
                                    bs = bs,
                                    html_fields = html_fields,
                                    dt = dt,
        )


    def POST( self, id="index" ):

        i = web.input()

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        fields = dic.get('fields')

        try:
            file = codecs.open(PANEO_SITE_DATA_DIR+id+'.html',"r","utf8")
            bs = BeautifulSoup(file.read(),"html5lib",fromEncoding="utf8")
            file.close()
        except:
            pass

        if fields is None:
            fields = {}

        for img in bs.find_all('img'):
            paneo_type = img.get('data-paneo-type')
            paneo_name = img.get('data-paneo-name')
            title = img.get('title')
            if paneo_type is not None and paneo_name is not None:
                k = "img_%s_%s" % ( id , paneo_name )
                #画像の削除
                if i.has_key(k+'_file_del'):
                    if os.path.exists(PANEO_SITE_DATA_DIR + "img/" + k):
                        os.remove(PANEO_SITE_DATA_DIR + "img/" + k)

                if i.has_key(k+'_file'):
                    if i[k+'_file'] != "":
                        fout = open(PANEO_SITE_DATA_DIR + "img/" + k,'wb') # creates the file where the uploaded file should be stored
                        fout.write(i[k+'_file']) # writes the uploaded file to the newly created file.
                        fout.close() # closes the file, upload complete.

                #data
                if i[k+'_alt'] != "":
                    alt =  i[k+'_alt']
                else:
                    alt = img.get('alt')

                if i[k + '_src'] != "":
                    src =  i[k+'_src']
                else:
                    src = img.get('src')

                fields[k] = {
                        'alt':alt,
                        'src':src,
                        'src_on':i.has_key(k+'_src_on'),
                }
                dic['fields'] = fields


        for a in bs.find_all('a'):
            paneo_type = a.get('data-paneo-type')
            paneo_name = a.get('data-paneo-name')
            title = a.get('title')
            img = a.find('img')
            if paneo_type is not None and paneo_name is not None and img is not None:
                k = "img_%s_%s" % (id,paneo_name) 
                #画像の削除
                if i.has_key(k+'_file_del'):
                    if os.path.exists(PANEO_SITE_DATA_DIR + "img/" + k):
                        os.remove(PANEO_SITE_DATA_DIR + "img/" + k)

                if i.has_key(k+'_file'):
                    if i[k+'_file'] != "":
                        fout = open(PANEO_SITE_DATA_DIR + "img/" + k,'wb')
                        fout.write(i[k+'_file'])
                        fout.close()

                #data
                if i[k+'_alt'] != "":
                    alt =  i[k+'_alt']
                else:
                    alt = img.get('alt')

                if i[k + '_src'] != "":
                    src =  i[k+'_src']
                else:
                    src = img.get('src')

                if i[k + '_href'] != "":
                    href =  i[k+'_href']
                else:
                    href = a.get('href')

                fields[k] = {
                        'alt':alt,
                        'src':src,
                        'src_on':i.has_key(k+'_src_on'),
                        'href':href,
                }
                dic['fields'] = fields

        dic.close()
       
        return self.GET( id )

